package com.proxyclient.client;

/**
 * API异常类
 */
public class ApiException extends Exception {
    private int errorCode;
    
    public ApiException(String message) {
        super(message);
    }
    
    public ApiException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }
    
    public ApiException(String message, Throwable cause) {
        super(message, cause);
    }
    
    public ApiException(String message, int errorCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }
    
    public int getErrorCode() {
        return errorCode;
    }
    
    @Override
    public String toString() {
        if (errorCode != 0) {
            return "API错误 " + errorCode + ": " + getMessage();
        } else {
            return "API错误: " + getMessage();
        }
    }
}