package com.proxyclient.client.example;

import com.proxyclient.client.ProxyClient;
import com.proxyclient.client.ApiException;
import com.proxyclient.client.model.FlowAccountInfo;
import com.proxyclient.client.model.PackageInfo;
import com.proxyclient.client.model.FlowDetailInfo;

import java.util.List;

/**
 * 使用示例
 */
public class ExampleUsage {
    public static void main(String[] args) {
        // 配置客户端
        ProxyClient.Config config = new ProxyClient.Config("your_apikey_here")
                .setTimeout(30000);
        
        try {
            // 创建客户端
            ProxyClient client = new ProxyClient(config);
            
            System.out.println("=== proxyclient Java Client Examples ===");
            
            // 示例1: 创建流量线路
            System.out.println("\n1. 创建流量线路...");
            try {
                List<FlowAccountInfo> accounts = client.createAccount("US", 60);
                System.out.println("创建成功，账户数量: " + accounts.size());
                for (FlowAccountInfo account : accounts) {
                    System.out.println("账户: " + account.getAccount() + 
                                     ", 国家: " + account.getCountry() +
                                     ", 代理IP: " + account.getProxyIp() + ":" + account.getS5Port());
                }
            } catch (ApiException e) {
                System.out.println("创建账户失败: " + e.getMessage());
            }
            
            // 示例2: 获取流量线路列表
            System.out.println("\n2. 获取流量线路列表...");
            try {
                List<FlowAccountInfo> accountList = client.getAccountList("US", 0, 10);
                System.out.println("获取到 " + accountList.size() + " 个账户");
                for (FlowAccountInfo account : accountList) {
                    System.out.println("账户ID: " + account.getAccountId() + 
                                     ", 账号: " + account.getAccount() + 
                                     ", 国家: " + account.getCountry());
                }
            } catch (ApiException e) {
                System.out.println("获取账户列表失败: " + e.getMessage());
            }
            
            // 示例3: 获取套餐信息
            System.out.println("\n3. 获取套餐信息...");
            try {
                PackageInfo packageInfo = client.getPackageInfo();
                System.out.println("总流量: " + packageInfo.getTrafficTotal() + " " + packageInfo.getUnit());
                System.out.println("已使用: " + packageInfo.getTrafficUsed() + " " + packageInfo.getUnit());
                System.out.println("剩余流量: " + packageInfo.getTrafficRemain() + " " + packageInfo.getUnit());
                System.out.println("账户数量: " + packageInfo.getFlowAccountCount());
            } catch (ApiException e) {
                System.out.println("获取套餐信息失败: " + e.getMessage());
            }
            
            // 示例4: 查询流量明细
            System.out.println("\n4. 查询流量明细...");
            try {
                List<FlowDetailInfo> trafficDetails = client.getTrafficDetail(
                    "", // 空字符串表示查询全部账户
                    "2025-11-01 00:00:00",
                    "2025-11-30 23:59:59"
                );
                System.out.println("查询到 " + trafficDetails.size() + " 条流量记录");
                for (int i = 0; i < Math.min(trafficDetails.size(), 3); i++) { // 只显示前3条
                    FlowDetailInfo detail = trafficDetails.get(i);
                    System.out.println("日期: " + detail.getDate() + 
                                     ", 账户: " + detail.getAccount() + 
                                     ", 流量: " + detail.getTraffic());
                }
            } catch (ApiException e) {
                System.out.println("查询流量明细失败: " + e.getMessage());
            }
            

            System.out.println("\n=== 示例执行完成 ===");
            
        } catch (ApiException e) {
            System.err.println("客户端初始化失败: " + e.getMessage());
        }
    }
}