package com.proxyclient.client.model;

import com.google.gson.annotations.SerializedName;

/**
 * 流量账户信息
 */
public class FlowAccountInfo {
    @SerializedName("account_id")
    private long accountId;
    
    private String account;
    
    @SerializedName("proxy_ip")
    private String proxyIp;
    
    @SerializedName("s5_port")
    private int s5Port;
    
    @SerializedName("http_port")
    private int httpPort;
    
    private String password;
    private String country;
    private int ttl;
    
    @SerializedName("traffic_used")
    private long trafficUsed;
    
    // 构造方法、getter、setter保持不变...
    // 默认构造函数
    public FlowAccountInfo() {}
    
    // 全参构造函数
    public FlowAccountInfo(long accountId, String account, String proxyIp, int s5Port, 
                          int httpPort, String password, String country, int ttl, long trafficUsed) {
        this.accountId = accountId;
        this.account = account;
        this.proxyIp = proxyIp;
        this.s5Port = s5Port;
        this.httpPort = httpPort;
        this.password = password;
        this.country = country;
        this.ttl = ttl;
        this.trafficUsed = trafficUsed;
    }
    
    // Getter和Setter方法
    public long getAccountId() { return accountId; }
    public void setAccountId(long accountId) { this.accountId = accountId; }
    
    public String getAccount() { return account; }
    public void setAccount(String account) { this.account = account; }
    
    public String getProxyIp() { return proxyIp; }
    public void setProxyIp(String proxyIp) { this.proxyIp = proxyIp; }
    
    public int getS5Port() { return s5Port; }
    public void setS5Port(int s5Port) { this.s5Port = s5Port; }
    
    public int getHttpPort() { return httpPort; }
    public void setHttpPort(int httpPort) { this.httpPort = httpPort; }
    
    public String getPassword() { return password; }
    public void setPassword(String password) { this.password = password; }
    
    public String getCountry() { return country; }
    public void setCountry(String country) { this.country = country; }
    
    public int getTtl() { return ttl; }
    public void setTtl(int ttl) { this.ttl = ttl; }
    
    public long getTrafficUsed() { return trafficUsed; }
    public void setTrafficUsed(long trafficUsed) { this.trafficUsed = trafficUsed; }
    
    @Override
    public String toString() {
        return "FlowAccountInfo{" +
                "accountId=" + accountId +
                ", account='" + account + '\'' +
                ", proxyIp='" + proxyIp + '\'' +
                ", s5Port=" + s5Port +
                ", httpPort=" + httpPort +
                ", password='" + password + '\'' +
                ", country='" + country + '\'' +
                ", ttl=" + ttl +
                ", trafficUsed=" + trafficUsed +
                '}';
    }
}