package com.proxyclient.client.model;

import com.google.gson.annotations.SerializedName;

/**
 * 套餐信息
 */
public class PackageInfo {
    @SerializedName("traffic_total")
    private long trafficTotal;
    
    @SerializedName("traffic_used")
    private long trafficUsed;
    
    @SerializedName("traffic_remain")
    private long trafficRemain;
    
    @SerializedName("flow_account_count")
    private long flowAccountCount;
    
    private String unit;
    
    // 构造方法、getter、setter保持不变...
    // 默认构造函数
    public PackageInfo() {}
    
    // 全参构造函数
    public PackageInfo(long trafficTotal, long trafficUsed, long trafficRemain, 
                      long flowAccountCount, String unit) {
        this.trafficTotal = trafficTotal;
        this.trafficUsed = trafficUsed;
        this.trafficRemain = trafficRemain;
        this.flowAccountCount = flowAccountCount;
        this.unit = unit;
    }
    
    // Getter和Setter方法
    public long getTrafficTotal() { return trafficTotal; }
    public void setTrafficTotal(long trafficTotal) { this.trafficTotal = trafficTotal; }
    
    public long getTrafficUsed() { return trafficUsed; }
    public void setTrafficUsed(long trafficUsed) { this.trafficUsed = trafficUsed; }
    
    public long getTrafficRemain() { return trafficRemain; }
    public void setTrafficRemain(long trafficRemain) { this.trafficRemain = trafficRemain; }
    
    public long getFlowAccountCount() { return flowAccountCount; }
    public void setFlowAccountCount(long flowAccountCount) { this.flowAccountCount = flowAccountCount; }
    
    public String getUnit() { return unit; }
    public void setUnit(String unit) { this.unit = unit; }
    
    @Override
    public String toString() {
        return "PackageInfo{" +
                "trafficTotal=" + trafficTotal +
                ", trafficUsed=" + trafficUsed +
                ", trafficRemain=" + trafficRemain +
                ", flowAccountCount=" + flowAccountCount +
                ", unit='" + unit + '\'' +
                '}';
    }
}