/**
 * 流量账户信息
 */
class FlowAccountInfo {
    /**
     * @param {Object} data
     * @param {number} data.account_id
     * @param {string} data.account
     * @param {string} data.proxy_ip
     * @param {number} data.s5_port
     * @param {number} data.http_port
     * @param {string} data.password
     * @param {string} data.country
     * @param {number} data.ttl
     * @param {number} data.traffic_used
     */
    constructor(data = {}) {
        this.account_id = data.account_id || 0;
        this.account = data.account || '';
        this.proxy_ip = data.proxy_ip || '';
        this.s5_port = data.s5_port || 0;
        this.http_port = data.http_port || 0;
        this.password = data.password || '';
        this.country = data.country || '';
        this.ttl = data.ttl || 0;
        this.traffic_used = data.traffic_used || 0;
    }

    toJSON() {
        return {
            account_id: this.account_id,
            account: this.account,
            proxy_ip: this.proxy_ip,
            s5_port: this.s5_port,
            http_port: this.http_port,
            password: this.password,
            country: this.country,
            ttl: this.ttl,
            traffic_used: this.traffic_used
        };
    }
}

/**
 * 套餐信息
 */
class PackageInfo {
    /**
     * @param {Object} data
     * @param {number} data.traffic_total
     * @param {number} data.traffic_used
     * @param {number} data.traffic_remain
     * @param {number} data.flow_account_count
     * @param {string} data.unit
     */
    constructor(data = {}) {
        this.traffic_total = data.traffic_total || 0;
        this.traffic_used = data.traffic_used || 0;
        this.traffic_remain = data.traffic_remain || 0;
        this.flow_account_count = data.flow_account_count || 0;
        this.unit = data.unit || '';
    }

    toJSON() {
        return {
            traffic_total: this.traffic_total,
            traffic_used: this.traffic_used,
            traffic_remain: this.traffic_remain,
            flow_account_count: this.flow_account_count,
            unit: this.unit
        };
    }
}

/**
 * 流量详情信息
 */
class FlowDetailInfo {
    /**
     * @param {Object} data
     * @param {number} data.traffic
     * @param {string} data.date
     * @param {string} data.account
     */
    constructor(data = {}) {
        this.traffic = data.traffic || 0;
        this.date = data.date || '';
        this.account = data.account || '';
    }

    toJSON() {
        return {
            traffic: this.traffic,
            date: this.date,
            account: this.account
        };
    }
}

/**
 * API错误类
 */
class ApiError extends Error {
    /**
     * @param {string} message
     * @param {number} code
     */
    constructor(message, code = 0) {
        super(message);
        this.name = 'ApiError';
        this.code = code;
    }

    toString() {
        return `API错误 ${this.code}: ${this.message}`;
    }
}

module.exports = {
    FlowAccountInfo,
    PackageInfo,
    FlowDetailInfo,
    ApiError
};